<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("sendtrainingmail", "function sendtrainingmail(id){
    var r = confirm('Send notification to staff regarding training?');
        if(r==true)
        {	
            jQuery.ajax({
                'type'      : 'post',
                'data'      : 'id=' + id,
                'dataType'  : 'json',  
                'url'       : $('#liveSite').val()+'index.php?r=hr/hrtraining/sendtrainingmail',
                'cache'     : false,
                'success'   :function(data){
                    if(data.status=='success'){
                        t8.success('Mail Send SuccessFully!');
                        reloadTable('#tbl_employee_training_details');
                    }else {
                        t8.error('Error while Delete');
                    }
               }
            });
        }
};", CClientScript::POS_HEAD);
$cs->registerScript("deletetrainingdetail", "function deletetrainingdetail(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {	
            jQuery.ajax({
                'type'      : 'post',
                'data'      : 'id=' + id,
                'dataType'  : 'json',  
                'url'       : $('#liveSite').val()+'index.php?r=hr/hrtraining/deletetrainingdetail',
                'cache'     : false,
                'success'   :function(data){
                    if(data.status=='success'){
                        t8.success('Deleted SuccessFully!');
                        reloadTable('#tbl_employee_training_details');
                    }else {
                        t8.error('Error while Delete');
                    }
               }
            });
        }
};", CClientScript::POS_HEAD);
$cs->registerScript("loaddetails", 'function filterDataTable(){
        var table_id ="#tbl_employee_training_details";
        var table = $(table_id).DataTable({
            scrollY         : "645px",
           // scrollX         : "true",
           // scrollCollapse  : true,
            pageLength      : 50,
			processing: true,
            ajax: {
                url: "' . Yii::app()->createUrl('hr/hrtraining/GetTrainingDetails') . '",
                type: "POST",
                cache : false,
            },
            serverSide:     true,
            fixedColumns:   true,
			processing: true,
            fixedHeader: {
                headerOffset: $("header.main").outerHeight()
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                 AddContextMenu(nRow, aData);
            }
        } );
        $(".dataTables_scrollFoot").hide();
	}	
		
    $(document).ready(function() {  		
      filterDataTable();
    });', CClientScript::POS_HEAD);
?>
<script>
    function AddContextMenu(row, datas) {
        let items = {};
       
        if (datas[6].edit_training !== 0) {
            items.edit = {
                name: "Edit",
                icon: "fa-edit",
                callback: function () {
                    loadPopupModal("hr/hrtraining/create&id=" + datas[6].id, "Edit Training Detail ", "xl");
                }
            };
        }
        
        if (datas[5].delete_training !== 0) {
            items.delete = {
                name: "Delete",
                icon: "fa-trash-o",
                callback: function () {
                    deletetrainingdetail(datas[6].id);
                }
            };
        }
        if (datas[5].sendmail_training !== 0) {
            items.sendmail = {
                name: "Send Mail",
                icon: "fa-mail-forward",
                callback: function () {
                    sendtrainingmail(datas[6].id);
                }
            };
        }
        if (Object.keys(items).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: items
            });
        }
    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">Training
<?php if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_training_add']) || Yii::app()->user->authorised_user == 1) { ?>
            <div class="pull-right">			   
                <a class="ad-btn" onclick="loadPopupModal('hr/hrtraining/create', 'Add Training Details', 'xl')">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            </div>
<?php } ?>                
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_employee_training_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>                                      
                        <th>Course</th> 
                        <th>Training Subject</th> 
                        <th>Provider</th>
                        <th>Training Date</th>
                        <th>Fee/Head</th>   
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>