<div class="stats-table">

  <!-- Header Row -->
  <div class="stats-header">
    <div></div>
    <div class="header-this">This Year<br><small></small></div>
    <div class="header-prev">Prev Year<br><small></small></div>
  </div>

  <?php
  $allCustomers = array_unique(array_merge(
    array_keys($currentYearSales),
    array_keys($lastYearSales)
  ));
  
  foreach ($allCustomers as $customerName):
    $shortName = mb_substr($customerName, 0, 21);
    
    $currentSales = isset($currentYearSales[$customerName]) ? number_format($currentYearSales[$customerName], 2) : '-';
    $lastSales = isset($lastYearSales[$customerName]) ? number_format($lastYearSales[$customerName], 2) : '-';
    
    $currentInvoices = isset($currentYearInvoiceCounts[$customerName]) ? $currentYearInvoiceCounts[$customerName] : '-';
    $lastInvoices = isset($lastYearInvoiceCounts[$customerName]) ? $lastYearInvoiceCounts[$customerName] : '-';
  ?>

  <div class="stats-row">
    <div class="stats-label" title="<?= htmlspecialchars($customerName) ?>">
      <?= htmlspecialchars($shortName) ?>
    </div>

    <div class="stats-box">
      <span><?= $currentInvoices ?></span>  <span class="spn-last"><?= $currentSales?></span>
    </div>

    <div class="stats-box-prev">
      <span><?= $lastInvoices ?></span>  <span class="spn-last"><?= $lastSales ?></span>
    </div>
  </div>

  <?php endforeach; ?>

</div>
